<?php

namespace App\Http\Controllers\Api;

use App\Enums\TxnStatus;
use App\Enums\TxnType;
use App\Events\UserReferred;
use App\Facades\Txn\Txn;
use App\Http\Controllers\Controller;
use App\Http\Controllers\HelperController;
use App\Models\Admin;
use App\Models\Ranking;
use App\Models\Sender;
use App\Models\Transaction;
use App\Models\User;
use App\Providers\RouteServiceProvider;
use App\Rules\Recaptcha;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Validation\Rule;
use Illuminate\Validation\Rules;
use Illuminate\Support\Facades\Validator;

class ApiController extends Controller
{
    public function register(Request $request){


        $validator = Validator::make($request->all(), [
            'first_name' => ['required', 'string', 'max:255'],
            'last_name' => ['required', 'string', 'max:255'],
            'username' => ['required', 'string', 'max:255', 'unique:users'],
            'country' => ['required', 'string', 'max:255'],
            'phone' => ['required', 'string', 'max:255'],
            'phone_prefix' => ['required'],
            'country_iso_2' => ['required'],
            'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'confirmed', Rules\Password::defaults()],
            'i_agree' => ['required'],
            'auth_token' => ['required'],
        ]);


        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }


        $sender = Sender::where('token', $request->auth_token)->first();
        if(!$sender){
            return response()->json(['errors' => ['auth_token' => ['Invalid Auth Token']]], 422);
        }
        if($sender->status == 0){
            return response()->json(['errors' => ['auth_token' => ['Invalid Auth Token']]], 422);
        }

        $input = $request->all();

        $phone = $input['phone_prefix'] . ' ' . $input['phone'];


        $rank = Ranking::find(1);


        $user = User::create([
            'ranking_id' => $rank->id,
            'rankings' => json_encode([$rank->id]),
            'first_name' => $input['first_name'],
            'last_name' => $input['last_name'],
            'username' => $input['username'],
            'country' => $input['country_iso_2'],
            'phone' => $phone,
            'email' => $input['email'],
            'secret' => Str::random(16),
            'is_api' => $sender->id,
            'new_status' => 'New',
            'custom_status'=>$request->custom_status,
            'password' => Hash::make($input['password']),
        ]);

        $user = User::find($user->id);
        if ($rank->bonus > 0) {
            Txn::new($rank->bonus, 0, $rank->bonus, 'system', 'Ranking Bonus From ' . $rank->ranking, TxnType::Bonus, TxnStatus::Success, null, null, $user->id);
            $user->increment('profit_balance', $rank->bonus);
        }

       // event(new UserReferred(request()->cookie('ref'), $user));

        if (setting('referral_signup_bonus', 'permission') && (double)setting('signup_bonus', 'fee') > 0) {
            $signupBonus = (double)setting('signup_bonus', 'fee');
            $user->increment('profit_balance', $signupBonus);
            Txn::new($signupBonus, 0, $signupBonus, 'system', 'Signup Bonus', TxnType::SignupBonus, TxnStatus::Success, null, null, $user->id);
        }
        $user->login_url = route('login.secret',[$user->id, $user->secret]);

        HelperController::sendWebNotification(Admin::find(1)->fcm_token,'New Lead Registered','New Lead Registered from account '. $sender->name);
        return response()->json([
            'message' => 'Registered',
            'data'=>$user->setAppends([]),

        ]);
    }

    public function statuses(Request $request){
        $validator = Validator::make($request->all(), [
            'auth_token' => ['required'],
        ]);

        if ($validator->fails()) {
            return response()->json(['errors' => $validator->errors()], 422);
        }

        $sender = Sender::where('token', $request->auth_token)->first();

        if(!$sender){
            return response()->json(['errors' => ['auth_token' => ['Invalid Auth Token']]], 422);

        }
        if($sender->status == 0){
            return response()->json(['errors' => ['auth_token' => ['Invalid Auth Token']]], 422);
        }


        $users = User::query()
            ->where('is_api','=',$sender->id)
            ->with('deposit','agent');
        if ($request->has('page')) {
            $secondPageNumber = $request->page;
        }
        if ($request->has('new_status')) {
            $users->where('new_status',$request->new_status);
        }
        if($request->has('deposit_exists') && $request->deposit_exists == 1){
            $users->whereHas('deposit');

        }elseif ($request->has('deposit_exists') && $request->deposit_exists == 0){
            $users->whereDoesntHave('deposit');
        }
        if($request->input('start_date') && $request->input('end_date')){
            $users->whereBetween('created_at', [$request->input('start_date'), $request->input('end_date')]);
        }

        $users = $users->paginate($request->get('limit', 250));
        foreach ($users as $user){
            $user->first_deposit = Transaction::where('type', TxnType::Deposit)
                ->where('user_id', $user->id)
                ->where('status', TxnStatus::Success)->orderBy('id','asc')
                ->first();
            if($user->first_deposit){
                $user->first_deposit->updated_at = Carbon::parse($user->first_deposit->updated_at)->format('M d Y h:i');
            }
            $user->login_url = route('login.secret',[$user->id, $user->secret]);
        }
        return response()->json([
            'data'=>$users,

        ]);
    }
}
