<?php

namespace App\Http\Controllers\Backend;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Yajra\DataTables\Facades\DataTables;

class AgentController extends Controller
{
    public function users(Request $request)
    {
        if ($request->ajax()) {

        $data = User::where('agent_id','=',\Auth::user()->id)->latest();
        return Datatables::of($data)
            ->addIndexColumn()
            ->editColumn('avatar', 'backend.user.include.__avatar')
            ->editColumn('kyc', 'backend.user.include.__kyc')
            ->editColumn('status', 'backend.user.include.__status')
            ->editColumn('balance', function ($request) {
                return $request->balance . ' ' . setting('site_currency');
            })
            ->editColumn('email', function ($request) {
                return safe($request->email);
            })
            ->editColumn('username', function ($request) {
                return safe($request->username);
            })
            ->editColumn('total_profit', function ($request) {
                return $request->total_profit . ' ' . setting('site_currency');
            })
            ->addColumn('action', 'backend.agent.users.includes.__action')
            ->rawColumns(['avatar', 'kyc', 'status', 'action','new_status'])
            ->make(true);
    }

        return view('backend.agent.users.index');
    }

    public function changeStatus(Request $request){
        $user = User::find($request->id);
        if($user->agent_id == \Auth::user()->id){
            $user->new_status = $request->new_status;
            $user->custom_status = $request->custom_status;
            $user->save();
            $status = 'success';
            $message = __('Status Change Successfully');
            notify()->$status($message, $status);
            return redirect()->back();
        }
        $status = 'warning';

        $message = __('Something went wrong');
        notify()->$status($message, $status);
        return redirect()->back();
    }
}
