@extends('backend.layouts.app')
@section('title')
    {{ __('Manage Sender') }}
@endsection
@section('content')
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title">{{ __('Manage Senders') }}</h2>
                            @can('role-create')
                                <a href="" class="title-btn" type="button" data-bs-toggle="modal"
                                   data-bs-target="#senderModal"><i
                                            icon-name="plus-circle"></i>{{ __('Add New Sender') }}
                                </a>
                            @endcan
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-card">
                        <div class="site-card-body">
                            <div class="site-table table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th scope="col">{{ __('Name') }}</th>
                                        <th scope="col">{{ __('token') }}</th>
                                        <th scope="col">{{ __('Status') }}</th>
                                        <th scope="col">{{ __('Total Leads') }}</th>
                                        <th scope="col">{{ __('Action') }}</th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    @foreach($senders as $sender)
                                        <tr>
                                            <td>
                                                <strong>{{$sender->name}}</strong>
                                            </td>

                                            <td>
                                                <strong>{{$sender->token}}</strong>
                                            </td>
                                            <td>
                                                @if($sender->status)
                                                    <div class="site-badge success">{{ __('Active') }}</div>
                                                @else
                                                    <div class="site-badge danger">{{ __('InActive') }}</div>
                                                @endif

                                            </td>
                                            <td>
                                                <strong>{{$sender->users->count()}}</strong>
                                            </td>
                                            <td>
                                                <button class="round-icon-btn primary-btn"
                                                        data-id="{{$sender->id}}" type="button" id="edit"
                                                        data-bs-toggle="tooltip" title=""
                                                        data-bs-placement="top"
                                                        data-bs-original-title="Edit Sender">
                                                    <i icon-name="edit-3"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    @endforeach

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal for Add New sender -->
        @can('role-create')
            @include('backend.sender.modal.__new_sender');
        @endcan
        <!-- Modal for Add New sender-->

        <!-- Modal for Edit sender -->
        @can('role-edit')
            @include('backend.sender.modal.__edit_sender')
        @endcan
        <!-- Modal for Edit sender-->

    </div>
@endsection

@section('script')
    <script>

        $('body').on('click', '#edit', function (event) {
            "use strict";
            event.preventDefault();
            $('#edit-sender-body').empty();
            var id = $(this).data('id');

            $.get('sender/' + id + '/edit', function (data) {

                $('#editModal').modal('show');
                $('#edit-sender-body').append(data);

            })
        });

    </script>
@endsection
