@php
    $agents = \App\Models\Admin::whereHas(
    'roles', function($q){
        $q->where('name', 'Support Agent');
    }
)->get();

@endphp
<div
    class="modal fade"
    id="assignAgent"
    tabindex="-1"
    aria-labelledby="sendEmailModalLabel"
    aria-hidden="true"
>
    <div class="modal-dialog modal-md modal-dialog-centered">
        <div class="modal-content site-table-modal">
            <div class="modal-body popup-body">
                <button
                    type="button"
                    class="btn-close"
                    data-bs-dismiss="modal"
                    aria-label="Close"
                ></button>
                <div class="popup-body-text">
                    <h3 class="title mb-4"> Change Status <span id="name_agent">{{ $name ?? ''}}</span></h3>
                    <form action="{{route('admin.user.change-agent')}}" method="post" id="send-mail-form">
                        @csrf

                        <input type="hidden" name="id" value="{{ $id ?? 0}}" id="userId_agent">

                        <div class="site-input-groups">
                            <label for="" class="box-input-label">Select Support Agent</label>
                            <select name="agent_id" class="form-control" id="agent_id">
                              @foreach($agents as $agent)
                                    <option value="{{$agent->id}}">{{$agent->name}}</option>
                              @endforeach
                            </select>
                        </div>
                        <div class="action-btns">
                            <button type="submit" class="site-btn-sm primary-btn me-2">
                                <i icon-name="send"></i>
                                Change
                            </button>
                            <a
                                href="#"
                                class="site-btn-sm red-btn"
                                data-bs-dismiss="modal"
                                aria-label="Close"
                            >
                                <i icon-name="x"></i>
                                {{ __('Close') }}
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
