@extends('backend.layouts.app')
@section('title')
    {{ __('All Customers') }}
@endsection
@section('content')
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title">{{ __('All Customers') }}</h2>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-card">
                        <div class="site-card-body table-responsive">
                            <div class="site-datatable">
                                <table id="dataTable" class="display data-table">
                                    <thead>
                                    <tr>
                                        <th>{{ __('Avatar') }}</th>
                                        <th>{{ __('User') }}</th>
                                        <th>{{ __('Email') }}</th>
                                        <th>{{ __('Balance') }}</th>
                                        <th>{{ __('Profit') }}</th>
                                        <th>{{ __('KYC') }}</th>
                                        <th>{{ __('Support Agent') }}</th>
                                        <th>{{ __('Status') }}</th>
                                        <th>{{ __('New Status') }}</th>
                                        <th>{{ __('Custom Status') }}</th>
                                        <th>{{ __('Action') }}</th>
                                    </tr>
                                    </thead>
                                    <tbody>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                    <!-- Modal for Send Email -->
                    @can('customer-mail-send')
                        @include('backend.user.include.__mail_send')
                    @endcan
                    <!-- Modal for Send Email-->
                    @include('backend.user.include.__change_status')
                    @include('backend.user.include.__assign_agent')
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    ]
    <script>
        (function ($) {
            "use strict";

            var table = $('#dataTable').DataTable({
                processing: true,
                serverSide: true,
                ajax: "{{ route('admin.user.index') }}",
                columns: [
                    {data: 'avatar', name: 'avatar'},
                    {data: 'username', name: 'username'},
                    {data: 'email', name: 'email'},
                    {data: 'balance', name: 'balance'},
                    {data: 'total_profit', name: 'total_profit', orderable: false, searchable: false},
                    {data: 'kyc', name: 'kyc'},
                    {data: 'agent', name: 'agent_id'},
                    {data: 'status', name: 'status'},
                    {data: 'new_status', name: 'new_status'},
                    {data: 'custom_status', name: 'custom_status'},
                    {data: 'action', name: 'action', orderable: false, searchable: false},
                ]
            });


            //send mail modal form open
            $('body').on('click', '.send-mail', function () {
                var id = $(this).data('id');
                var name = $(this).data('name');
                $('#name').html(name);
                $('#userId').val(id);
                $('#sendEmail').modal('toggle')
            });

            $('body').on('click', '.change-status', function () {
                var id = $(this).data('id');
                console.log(id);
                var name = $(this).data('name');
                var status = $(this).data('status');
                $('#name_status').html(name);
                $('#userId_status').val(id);
                $('#new_status').val(status);
                $('#changeStatus').modal('toggle')
            });


            $('body').on('click', '.assign-agent', function () {
                var id = $(this).data('id');
                var name = $(this).data('name');
                var agent_id = $(this).data('agent_id');
                $('#name_agent').html(name);
                $('#userId_agent').val(id);
                $('#agent_id').val(agent_id);
                $('#assignAgent').modal('toggle')
            });

        })(jQuery);
    </script>
@endsection
