
<?php $__env->startSection('title'); ?>
    <?php echo e(__('Manage Sender')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="main-content">
        <div class="page-title">
            <div class="container-fluid">
                <div class="row">
                    <div class="col">
                        <div class="title-content">
                            <h2 class="title"><?php echo e(__('Manage Senders')); ?></h2>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role-create')): ?>
                                <a href="" class="title-btn" type="button" data-bs-toggle="modal"
                                   data-bs-target="#senderModal"><i
                                            icon-name="plus-circle"></i><?php echo e(__('Add New Sender')); ?>

                                </a>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-12">
                    <div class="site-card">
                        <div class="site-card-body">
                            <div class="site-table table-responsive">
                                <table class="table">
                                    <thead>
                                    <tr>
                                        <th scope="col"><?php echo e(__('Name')); ?></th>
                                        <th scope="col"><?php echo e(__('token')); ?></th>
                                        <th scope="col"><?php echo e(__('Status')); ?></th>
                                        <th scope="col"><?php echo e(__('Total Leads')); ?></th>
                                        <th scope="col"><?php echo e(__('Action')); ?></th>
                                    </tr>
                                    </thead>
                                    <tbody>
                                    <?php $__currentLoopData = $senders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sender): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td>
                                                <strong><?php echo e($sender->name); ?></strong>
                                            </td>

                                            <td>
                                                <strong><?php echo e($sender->token); ?></strong>
                                            </td>
                                            <td>
                                                <?php if($sender->status): ?>
                                                    <div class="site-badge success"><?php echo e(__('Active')); ?></div>
                                                <?php else: ?>
                                                    <div class="site-badge danger"><?php echo e(__('InActive')); ?></div>
                                                <?php endif; ?>

                                            </td>
                                            <td>
                                                <strong><?php echo e($sender->users->count()); ?></strong>
                                            </td>
                                            <td>
                                                <button class="round-icon-btn primary-btn"
                                                        data-id="<?php echo e($sender->id); ?>" type="button" id="edit"
                                                        data-bs-toggle="tooltip" title=""
                                                        data-bs-placement="top"
                                                        data-bs-original-title="Edit Sender">
                                                    <i icon-name="edit-3"></i>
                                                </button>
                                            </td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal for Add New sender -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role-create')): ?>
            <?php echo $__env->make('backend.sender.modal.__new_sender', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>;
        <?php endif; ?>
        <!-- Modal for Add New sender-->

        <!-- Modal for Edit sender -->
        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('role-edit')): ?>
            <?php echo $__env->make('backend.sender.modal.__edit_sender', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endif; ?>
        <!-- Modal for Edit sender-->

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('script'); ?>
    <script>

        $('body').on('click', '#edit', function (event) {
            "use strict";
            event.preventDefault();
            $('#edit-sender-body').empty();
            var id = $(this).data('id');

            $.get('sender/' + id + '/edit', function (data) {

                $('#editModal').modal('show');
                $('#edit-sender-body').append(data);

            })
        });

    </script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backend.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\wamp64\www\fiverr\capitalclaim\resources\views/backend/sender/index.blade.php ENDPATH**/ ?>